<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Smstransaction;
use App\Models\Smstesttransactions;
use App\Http\Requests\Bulkrequest;
use App\Models\User;
use App\Models\App;
use App\Models\Device;
use App\Models\Contact;
use App\Models\Template;
use App\Models\Reply;
use App\Models\Schedulecontact;
use App\Models\Schedulemessage;
use Carbon\Carbon;
use App\Traits\Whatsapp;
use Exception;
use Illuminate\Support\Facades\DB;

class MiscController extends Controller
{
    use Whatsapp;


    /**
     * sent message
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function onWhatsapp(Request $request)
    {
        $user = User::where('status', 1)->where('will_expire', '>', now())->where('authkey', $request->authkey)->first();

        $app = App::where('key', $request->appkey)->whereHas('device')->with('device')->where('status', 1)->first();

        if ($user == null || $app == null) {
            return response()->json(['error' => 'Invalid Auth and AppKey'], 401);
        }

        $inputs = $request->all();
        $validator = validator($inputs, [
            "whatsapp_id" => "required",
        ]);

        if ($validator->fails()) {
            return response()->json(
                [
                    "message" => __("Validation error"),
                    'errors' => $validator->errors()
                ],
                401,
            );
        }
      return $this->whatsappIdOnWhatsapp($app->device->id,$inputs['whatsapp_id']);
    }
}
