<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Smstransaction;
use App\Models\Smstesttransactions;
use App\Http\Requests\Bulkrequest;
use App\Models\User;
use App\Models\App;
use App\Models\Device;
use App\Models\Contact;
use App\Models\Template;
use App\Models\Reply;
use App\Models\Schedulecontact;
use App\Models\Schedulemessage;
use Carbon\Carbon;
use App\Traits\Whatsapp;
use Exception;
use Illuminate\Support\Facades\DB;

class ScheduleMessageController extends Controller
{
    use Whatsapp;


    /**
     * sent message
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = User::where('status', 1)->where('will_expire', '>', now())->where('authkey', $request->authkey)->first();
        $app = App::where('key', $request->appkey)->whereHas('device')->with('device')->where('status', 1)->first();

        if ($user == null || $app == null) {
            return response()->json(['error' => 'Invalid Auth and AppKey'], 401);
        }

        if (getUserPlanData('messages_limit', $user->id) == false) {
            return response()->json([
                'message' => __('Maximum Monthly Messages Limit Exceeded')
            ], 401);
        }
        if (getUserPlanData('schedule_message', $user->id) == false) {
            return response()->json([
                'message' => __('Schedule message modules is not available your plan')
            ], 401);
        }
        $inputs = $request->all();


        $validator = validator($inputs, [
            "name" => "required",
            "message" => "required_without:template_id",
            "recipients" => "required|array",
            "template_id" => "required_without:message",
            "schedule_at" => "nullable",
            "timezone" => "nullable",
            "message_type" => "required|in:plain_text,template,text-with-media",
            "file" => ["nullable", "file", "mimes:jpg,png,webp,pdf,docx,xlsx,csv,txt"],
            "file_url" => ["nullable"],
        ]);

        if ($validator->fails()) {
            return response()->json(
                [
                    "message" => __("Validation error"),
                    'errors' => $validator->errors()
                ],
                401,
            );
        }

        $filePath = null;


        if ($request->file_url) {
            $filePath = $request->file_url;
        } elseif ($request->hasFile("file")) {

            $filename = date("Y-m-d_H:i:s") . "_" . $request->file("file")->getClientOriginalName();
            $filePath = url($request->File("file")->storePubliclyAs('schedulemessageFiles', $filename, [
                "disk" => "public"
            ]));
        }


        DB::beginTransaction();
        try {
            $date = $request->schedule_at ?? Carbon::now()->addSeconds(20);
            $date = Carbon::parse($date);
            // $time= $date->format('g:i A');
            // $date= $date->toDate();
            $dateTime = Carbon::createFromFormat('Y-m-d H:i:s', $date, $request->timezone);
            $dateTime = $dateTime->copy()->tz(env('TIME_ZONE', 'UTC'));

            $device = $app->device;

            $schedulemessage = new Schedulemessage();
            $schedulemessage->user_id = $user->id;
            $schedulemessage->device_id = $device->id;
            $schedulemessage->title = $request->name;
            $schedulemessage->schedule_at = $dateTime;
            $schedulemessage->body = $request->message_type != 'template' ? $request->message : null;
            $schedulemessage->zone = $request->timezone;
            $schedulemessage->template_id = $request->message_type == 'template' ? $request->template_id : null;
            $schedulemessage->file = $filePath;
            $schedulemessage->save();

            $recipients =  $request->recipients;
            $recipients_arr = [];
            foreach ($recipients as $recipient) {
                $contact = Contact::updateOrCreate(
                    [
                        "user_id" => $user->id,
                        "phone" => $recipient,
                    ],
                    [
                        "user_id" => $user->id,
                        "phone" => $recipient,
                    ]
                );
                $recipients_arr[] = [
                    "contact_id" => $contact->id,
                    "schedulemessage_id" => $schedulemessage->id,
                ];
            }
            Schedulecontact::insert($recipients_arr);
            DB::commit();
            return response()->json(['message' => __('Schedule Message created successfully'), "schedule_message_id" => $schedulemessage->id], 200);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'Request Failed',
                "error" => $e->getMessage(),
            ], 401);
        }
    }

    public function show($id)
    {
        $schedulemessage = Schedulemessage::where('id', $id)->with("contacts")->first();
        if (empty($schedulemessage)) {
            return response()->json([
                'message' => 'Schedule message not found'
            ], 401);
        }


        return response()->json([
            'pendings' => $schedulemessage->contacts()->where('status_code', 0)->count(),
            'success' => $schedulemessage->contacts()->where('status_code', 1)->count(),
            'failed' => $schedulemessage->contacts()->where('status_code', 2)->count(),
        ], 200);
    }
}
